/**
 * \file: mspin_demo_iap2_connection.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN iAP2 Connection
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *          Thilo Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_DEMO_IAP2_CONNECTION_H_
#define MSPIN_DEMO_IAP2_CONNECTION_H_

#include <mspin_demo_types.h>
#include <mspin_demo_iap2_types.h>
#include <mspin_demo_iap2_utilities.h>
#include <mspin_demo_iap2_gadget_loader.h>
#include <mspin_demo_iap2_configuration_pfcfg.h>

#include <iap2_dlt_log.h> //needed for future iPod releases
#include <iap2_usb_role_switch.h>
#include <iap2_external_accessory_protocol_session.h>
#include <iap2_commands.h>       //for iAP2RequestAppLaunch()
#include <iap2_parameter_free.h> //for iAP2FreeiAP2RequestAppLaunchParameter()
#include <iap2_initialize_usb_gadget.h>
#include <iap2_init.h>


#define MYSPIN_DEMO_IAP2_LIBCOMPOSITE_MODULE_NAME     "libcomposite"
#define MYSPIN_DEMO_IAP2_GADGET_FFS_MODULE_NAME       "g_ffs"
#define MYSPIN_DEMO_IAP2_LINUX_USB_GADGET_MODULE_PATH "/lib/modules/%s/kernel/drivers/usb/gadget/%s.ko"

#define MYSPIN_DEMO_IAP2_FUNCTION_FS_NAME             "ffs"
#define MYSPIN_DEMO_IAP2_FUNCTION_FS_PATH             "/dev/ffs"
#define MYSPIN_DEMO_IAP2_CONFIG_FS_PATH               "/sys/kernel/config"
#define MYSPIN_DEMO_IAP2_FUNCTION_FS_TYPE             "functionfs"
#define MYSPIN_DEMO_IAP2_GADGET_NAME                  "iAP_Interface"
#define MYSPIN_DEMO_IAP2_UAC2GADGET_NAME              "uac2"

#define MAX_STRING_LEN                                256

typedef void (*iOSDeviceReady)(void *pToken, bool ready);
typedef void (*iOSDeviceDisconnected)(void *pToken);
typedef void (*EAPSessionStarted)(void *pToken);
typedef void (*EAPSessionStopped)(void *pToken);

class Iap2Connection
{
private:
    static mspin_demo_iap2_iOSDevice_t m_iAP2Device;
    static iOSDeviceReady m_Connect_CB;
    static iOSDeviceDisconnected m_Disconnected_CB;
    static EAPSessionStarted m_EAPSessionStarted_CB;
    static EAPSessionStopped m_EAPSessionStopped_CB;
    static BOOL m_EndMonitoring;

    Iap2Utilites m_iap2Utilites;
    GadgetLoader m_gadgetLoader;
    Iap2ConfigurationPfcfg m_iap2ConfigPfcfg;

    iAP2InitParam_t m_iAP2InitParameter;
    iAP2USBRoleSwitchInfo m_RoleSwitchInfo;
    udcParamInfo_t m_UdcParam;
    mqd_t m_MyspinMQFD;
    pthread_t m_PollThreadID;
    pthread_t m_AppThreadID;

    iAP2_usbg_config_t m_iAP2UsbgConfig;

    static S32 updateDeviceState_CB(iAP2Device_t* iap2Device,
            iAP2DeviceState_t state, void* context);
    static S32 startEANativeTransport_CB(iAP2Device_t* iap2Device, U8 iAP2iOSAppIdentifier,
            U8 sinkEndpoint, U8 sourceEndpoint, void* context);
    static S32 stopEANativeTransport_CB(iAP2Device_t* iap2Device, U8 iAP2iOSAppIdentifier,
            U8 sinkEndpoint, U8 sourceEndpoint, void* context);
    static S32 authenticationFailed_CB(iAP2Device_t* iap2Device,
            iAP2AuthenticationFailedParameter* authParameter, void* context);
    static S32 authenticationSucceeded_CB(iAP2Device_t* iap2Device,
            iAP2AuthenticationSucceededParameter* authParameter, void* context);
    static S32 identificationAccepted_CB(iAP2Device_t* iap2Device,
            iAP2IdentificationAcceptedParameter* idParameter, void* context);
    static S32 identificationRejected_CB(iAP2Device_t* iap2Device,
            iAP2IdentificationRejectedParameter* idParameter, void* context);
    static S32 powerUpdate_CB(iAP2Device_t* iap2Device,
            iAP2PowerUpdateParameter* powerupdateParameter, void* context);

    S32  initGadgetConfiguration(iAP2_usbg_config_t* usb_gadget_configuration, iAP2AccessoryInfo_t* p_iAP2AccessoryInfo);
    void iap2FreePtr(void** iap2PtrToFree);
    void deInitGadgetConfiguration(iAP2_usbg_config_t* usb_gadget_configuration);
    S32  switchOTGPortToDevice(void);
    S32  switchOTGPortToHost(void);
    int  configureAccessoryBasics(iAP2AccessoryConfig_t* pConfig, bool boardTypeSD);
    S32  configureInfo(iAP2AccessoryInfo_t* pAccInfo, iAP2TransportType_t transportType);
    void configureCallbacks(iAP2SessionCallbacks_t* pCallbacks);
    void configureStackCallbacks(iAP2StackCallbacks_t* pStackCallbacks);
    void configureEANativeTransportCallbacks(iAP2EANativeTransportCallbacks_t* pEANativeTransportCallbacks);
    int  configureAccessory(iAP2InitParam_t* pInitParam, bool boardTypeSD, void* pContext);
    pthread_t createThread(void* threadFunction, const char* thread_name, void* exinf);

    static void monitorDevices_CB(void* exinf);

public:
    Iap2Connection();
    ~Iap2Connection();

    static void registerDLT();
    static void unregisterDLT();

    S32 connect(std::string serial,
            iOSDeviceReady deviceReadyCB,
            iOSDeviceDisconnected deviceDisconnectedCB,
            EAPSessionStarted eapSessionStartedCB,
            EAPSessionStopped eapSessionStoppedCB,
            mspin_demo_connectionParameter_t *pDevice);
    void disconnect(void);

    S32 requestAppLaunch(bool withAlert);
    S32 powerSourceUpdate(void);
};

#endif /* MSPIN_DEMO_IAP2_CONNECTION_H_ */

